<?php

namespace App\Livewire\Auth;

use Livewire\Component;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;


class Login extends Component
{
    public $password;
    public $rut;
    public function render()
    {
        return view('livewire.auth.login');
    }
    public function login()
    {
        $rutLimpio = preg_replace('/[^0-9kK]/', '', $this->rut);
        $this->rut = $rutLimpio;


        //dd($this->rut);
        $this->validate([
           // 'rut' => 'required|string',
            'password' => 'required|string',
        ]);

        $user = User::where('rut', $this->rut)->first();
        //dd($user);
        //dd(Hash::check($this->password, $user->password));
        if (!$user || !Hash::check($this->password, $user->password)) {
            $this->addError('rut', 'Credenciales incorrectas');
            return;
        }

        Auth::login($user);
        return redirect()->route('main');
    }

}
