<?php

namespace App\Livewire;

use Livewire\Component;
use App\Services\BrevoService;

class BrevoMailTest extends Component
{
    public $toEmail;
    public $toName;
    public $subject;
    public $message;
    public $status;

    public function send(BrevoService $brevo)
    {
        $this->validate([
            'toEmail' => 'required|email',
            'toName' => 'required|string|min:2',
            'subject' => 'required|string|min:2',
            'message' => 'required|string|min:5',
        ]);

        try {
            $brevo->sendEmail(
                $this->toEmail,
                $this->toName,
                $this->subject,
                "<p>{$this->message}</p>"
            );

            $this->status = "✅ Correo enviado correctamente a {$this->toEmail}";
            $this->reset(['toEmail', 'toName', 'subject', 'message']);
        } catch (\Exception $e) {
            $this->status = "❌ Error al enviar: " . $e->getMessage();
        }
    }

    public function render()
    {
        return view('livewire.brevo-mail-test');
    }
}
