<?php

namespace App\Livewire\Horarios;

use Livewire\Component;
use App\Models\Horario;
class Asistencia extends Component
{
    public $fechas;
    public $horarios;

    public function render()
    {
        return view('livewire.horarios.asistencia');
    }
    public function mount()
    {
        $horarios = Horario::whereDate('fecha','2025-08-29')->get();
        $this->fechas = $horarios->map(fn($horario)=>$horario->fecha)->unique()->sort();

        $this->horarios =  $horarios;
    }
    public function marcar($horarioId, $personaId, $valor)
    {
        \DB::table('horario_persona')
            ->where('horario_id', $horarioId)
            ->where('persona_id', $personaId)
            ->update(['asistencia' => $valor]);

        // refrescar datos
        $this->dispatch('$refresh');
    }

}

