<?php

namespace App\Livewire\Personas;

use Livewire\Component;
use App\Models\Persona;
use App\Models\Horario;

use Illuminate\Support\Facades\DB;

class Inscritas extends Component
{
    public $personas;
    public $ultimas;
    public function render()
    {
        return view('livewire.personas.inscritas');
    }
    public function mount()
    {
        
        $this->personas = Persona::with(['horarios.taller'])->get();
        $horarios = Horario::get();
        $this->ultimas = \App\Models\Horario::with(['personas'])
        ->orderByDesc('created_at')
        ->take(10)
        ->get()
        ->flatMap(function ($horario) {
            return $horario->personas->map(function ($persona) use ($horario) {
                return (object)[
                    'persona' => $persona,
                    'horario' => $horario,
                ];
            });
        });
    }
}
