<?php

namespace App\Livewire\Personas;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On; 
use App\Models\Persona;
use App\Models\Taller;
use App\Models\Horario;
use Carbon\Carbon;
class Talleres extends Component
{
    public $talleres;
    public $persona;
    public $fechas;

    public $persona_id; // viene del contexto
    public $selecciones = []; // [ '2025-06-21' => horario_id ]

    public $talleresFechas ;

     public function mount($code=null)
    {
        if(is_null($code))
        {
            $this->persona = Auth()->User()->persona;
        }
        else
        {
            $this->persona = Persona::where('qrcode',$code)->get()->first();
        }

       // dd(Auth()->User()->persona);
        $this->talleres = Taller::get();

        /*
        $this->talleresFechas = Horario::whereBetween('fecha', [now(), now()->addDays(30)])
        ->pluck('fecha')
        ->unique()
        ->sort()
        ->values();
*/

    $this->talleresFechas = Horario::whereMonth('fecha',Carbon::now()->format('m') )->get()->map(fn($horario)=>$horario->fecha)->unique();

       // $this->talleresFechas = Horario::get()->map(fn($horario)=>$horario->fecha)->unique();
       // $this->fechas = $this->crearFechas();
    }
    

    #[On('actualizar')]
    public function actualizar()
    {
        $this->mount($this->persona );
    }
    public function render()
    {
        return view('livewire.personas.talleres');
    }

    public function anular($fecha, $horarioId)
    {
        //dd($horarioId);
        DB::table('horario_persona')
        ->where('persona_id', $this->persona->id)
        ->where('horario_id', $horarioId)
        ->where('fecha', $fecha)
        ->delete();
        $this->dispatch('actualizar');
    }
    public function inscrito($fecha)
    {
        return $this->persona->horarios()->wherePivot('fecha', $fecha)->count() >= 1;
    }

    public function reserva($fecha)
    {
        return $this->persona->horarios()->wherePivot('fecha', $fecha)->first();
    }

    public function toggleInscripcion($fecha, $horarioId)
    {

        
        $persona = $this->persona;

        $yaInscritoEseDia = $persona->horarios()->wherePivot('fecha', $fecha)->exists();

        if ($yaInscritoEseDia) {
            // Si ya estaba inscrito en ese día y es el mismo -> desinscribir
            $actual = $persona->horarios()->wherePivot('fecha', $fecha)->first();
            if ($actual->id == $horarioId) {
                $persona->horarios()->detach($actual->id);
                unset($this->selecciones[$fecha]);
            } else {
                // Si intenta inscribirse a otro: impedirlo o reemplazarlo
                session()->flash('error', 'Solo puedes seleccionar un taller por día.');
            }
        } else {
            // No hay inscripción, agregar
            $persona->horarios()->attach($horarioId, ['fecha' => $fecha]);
            $this->selecciones[$fecha] = $horarioId;
        }
    }
   

    public function hayTaller($fecha, $taller_id)
    {
        return Horario::whereDate('fecha',$fecha)->where('taller_id',$taller_id)->Get()->isnotempty();
    }

    static function crearFechas($firstDayOfMonth,$lastDayOfMonth)
    {
        $firstDayOfMonth     = Carbon::parse($firstDayOfMonth);
        $lastDayOfMonth = Carbon::parse($lastDayOfMonth);

        if ($firstDayOfMonth->dayOfWeek !== Carbon::MONDAY) {
            $firstDayOfMonth    = $firstDayOfMonth->previous(Carbon::MONDAY);
        }
        

        if ($lastDayOfMonth->dayOfWeek !== Carbon::SUNDAY) {
            $lastDayOfMonth    = $lastDayOfMonth->next(Carbon::SUNDAY);
        }

        $fechas = [];

        while ($firstDayOfMonth->lessThanOrEqualTo($lastDayOfMonth)) {
            $fechas[] = $firstDayOfMonth->copy();
            $firstDayOfMonth->addDay();
        }

        return $fechas;
    }

}
