<?php

namespace App\Livewire\Reservas;

use Livewire\Component;
use App\Models\Persona;
use App\Models\Taller;
use App\Models\Horario;
use Carbon\Carbon;

class ReservarSimple extends Component
{
    public $horarios;
    public $talleres;
    
    public $persona;
    public $inscritoHorarioId = null; // ID del horario inscrito (si existe)



    public $fechas;

   public function mount($persona)
    {
        // Fechas definidas
        $this->fechas = $this->crearFechas('2025-06-16', '2025-11-12');

        // Cargar la persona una sola vez
        $this->persona = Persona::findOrFail($persona);

        // Cargar horarios con relación de taller ya incluida
        $this->horarios = Horario::with('taller')->get();

        // Obtener talleres únicos directamente sin map() extra
        $this->talleres = $this->horarios->pluck('taller')->unique('id')->values();
    }

    public function actualizarInscripcion()
    {
        $horario = $this->persona->horarios()
            ->wherePivot('fecha', $this->fecha)
            ->first();

        $this->inscritoHorarioId = $horario?->id;
    }

    public function grabar($tallerId)
    {
        // Evita múltiples inscripciones
        if ($this->inscritoHorarioId) return;

        $horario = Horario::where('taller_id', $tallerId)
            ->whereDate('fecha', $this->fecha)
            ->first();

        if ($horario) {
            $this->persona->horarios()->attach($horario->id, ['fecha' => $this->fecha]);
            $this->actualizarInscripcion();
        }
    }

    public function eliminar()
    {
        if (!$this->inscritoHorarioId) return;

        $this->persona->horarios()->detach($this->inscritoHorarioId);
        $this->inscritoHorarioId = null;
    }

    public function render()
    {
        return view('livewire.reservas.reservar-simple');
    }




    static function crearFechas($firstDayOfMonth,$lastDayOfMonth)
    {
        $firstDayOfMonth     = Carbon::parse($firstDayOfMonth);
        $lastDayOfMonth = Carbon::parse($lastDayOfMonth);

        if ($firstDayOfMonth->dayOfWeek !== Carbon::MONDAY) {
            $firstDayOfMonth    = $firstDayOfMonth->previous(Carbon::MONDAY);
        }
        

        if ($lastDayOfMonth->dayOfWeek !== Carbon::SUNDAY) {
            $lastDayOfMonth    = $lastDayOfMonth->next(Carbon::SUNDAY);
        }

        $fechas = [];

        while ($firstDayOfMonth->lessThanOrEqualTo($lastDayOfMonth)) {
            $fechas[] = $firstDayOfMonth->copy();
            $firstDayOfMonth->addDay();
        }

        return $fechas;
    }
}
