<?php

namespace App\Livewire\Talleres;

use Livewire\Component;
use App\Models\Horario;
use App\Models\Taller;
use Carbon\Carbon;
class ListaAsistencia extends Component
{
    public $horario;
    public $personas;
    public $taller;
    public $fecha;
    public function render()
    {
        return view('livewire.talleres.lista-asistencia');
    }
    public function mount($fecha, Taller $taller)
    {
        $this->fecha = Carbon::parse($fecha);
        $tallerId = $taller->id;
        $this->taller = $taller;
        $horario = Horario::whereDate('fecha',$fecha)->where('taller_id',$tallerId)->get()->first();
        //dd(Horario::whereDate('fecha',$fecha)->get());
        $this->horario = $horario;
        $this->personas = $horario->personas->sortBy('nombres');
       // dd($this->personas );
        
    }
}
