<?php

namespace App\Livewire\Talleres;

use Livewire\Component;
use App\Models\Horario;
use Carbon\Carbon;
class ListasReservas extends Component
{
    public $fechas;
    public $horarios;
    public $talleres;

    public function render()
    {
        return view('livewire.talleres.listas-reservas');
    }

    public function mount()
    {
        $this->horarios = Horario::all();

        $this->talleres = $this->horarios
            ->pluck('taller')
            ->unique('id')
            ->values();

        $this->fechas = $this->horarios
            ->filter(function ($horario) {
                return $horario->fecha->format('m') == Carbon::now()->format('m');
            })
            ->pluck('fecha')
            ->unique()
            ->sort()
            ->values();           
    }

}
