<?php

namespace App\Livewire\Users\Auth;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class Login extends Component
{
    public $rut;
    public $password;
    public $error;
    public $persona;

    public function render()
    {
        return view('livewire.users.auth.login');
    }
    public function mount($rut = null)
    {
        $this->rut = $rut;

    }

    public function login()
    {
        //dd($this->rut);
        $this->validate([
           // 'rut' => 'required|string',
            'password' => 'required|string',
        ]);

        $user = User::where('rut', $this->rut)->first();
        //dd($user);
        //dd(Hash::check($this->password, $user->password));
        if (!$user || !Hash::check($this->password, $user->password)) {
            $this->addError('rut', 'Credenciales incorrectas');
            return;
        }

        Auth::login($user);
        return redirect()->route('dashboard');
    }

}
