<?php

namespace App\Livewire\Users;

use Livewire\Component;
use App\Models\Persona;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class InputLogin extends Component
{
    public Persona $persona;
    public $password = '';
    public $errorMessage = '';

    public function mount(Persona $persona)
    {
        $this->persona = $persona;
    }

    public function login()
    {
        
        $user = $this->persona->user();
        
        

        if (!$user || !Hash::check($this->password, $user->password)) {
            $this->errorMessage = 'Contraseña incorrecta.';
            return;
        }

        Auth::login($user);
        return redirect()->intended('/');
    }

    public function render()
    {
        return view('livewire.users.input-login');
    }
}
