<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Horario extends Model
{
    protected $table = "horarios";
    protected $fillable =[
        'id',
        'fecha',
        'taller_id',      
    ];

    public function cupos($fecha,$taller_id)
    {
        $inscritos = $this->personas;

        return $inscritos ;
    }


    public function personas()
    {
        return $this->belongsToMany(Persona::class)
                    ->withPivot('id','fecha','asistencia')
                    ->withTimestamps();
    }

    public function taller()
    {
        return $this->belongsTo(Taller::class);
    } 

    public function fecha(): Attribute
    {
        return Attribute::make(
            get: fn ($value) =>Carbon::parse($value),
        );
    }
}
