@props(['titulo' => null])
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $titulo ?? 'Club Deportivo Kardiafit' }}</title>
    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon" />

    @vite(['resources/css/app.css','resources/js/app.js'])
    @stack('styles')
    @livewireStyles

    <link href="{{ asset('fontawesome/css/fontawesome.css') }}" rel="stylesheet">
    <link href="{{ asset('fontawesome/css/solid.css') }}" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
</head>
<body class="flex flex-col min-h-screen bg-gradient-to-br from-rose-100 via-orange-50 to-amber-100 font-sans text-gray-800">

   <header class="bg-gradient-to-r from-red-700 via-gray-800 to-black text-white shadow-xl py-6 relative overflow-hidden">
    <div class="absolute inset-0 bg-[radial-gradient(circle_at_top_left,_var(--tw-gradient-stops))] from-red-800 via-transparent to-transparent opacity-30 z-0"></div>

    <div class="relative z-10 container mx-auto px-4 flex flex-col md:flex-row justify-between items-center">
        <!-- Logo -->
        <div class="mb-4 md:mb-0 flex items-center gap-4">
            <a href="/">
            <img src="{{ asset('img/kardiafit.png') }}" alt="Logo Kardiafit" class="h-20 w-auto">
            </a>
            <h1 class="text-3xl md:text-4xl font-extrabold tracking-wider uppercase text-white drop-shadow-md">
                Club Deportivo Kardiafit
            </h1>
        </div>

        <!-- Usuario / Auth -->
        <div class="text-right">
            @if (Auth()->check())
                <p class="text-sm font-semibold mb-1">Bienvenido, {{ Auth()->user()->name }}</p>
                @livewire('users.auth.logout')
            @else
                <span class="italic text-sm">Regístrate o inicia sesión</span>
            @endif
        </div>
    </div>

    <!-- Frase motivadora -->
    <div class="relative z-10 text-center mt-4 text-amber-300 font-semibold italic text-lg md:text-xl animate-pulse">
        “La constancia vence al talento. ¡Entrena con corazón, entrena con Kardiafit!”
    </div>
</header>


    <!-- Loader Fitness -->
    <div id="loader" class="fixed inset-0 z-50 flex flex-col items-center justify-center bg-black/90 text-white">
        <!-- Ícono de pesa animado -->
        <div class="mb-6 flex items-center gap-2 animate-bounce">
            <div class="w-2 h-10 bg-gray-400 rounded"></div>
            <div class="w-4 h-28 bg-pink-500 rounded-full"></div>
            <div class="w-6 h-40 bg-pink-500 rounded-full"></div>
            <div class="w-20 h-6 bg-gray-300 rounded"></div>
            <div class="w-6 h-40 bg-pink-500 rounded-full"></div>
            <div class="w-4 h-28 bg-pink-500 rounded-full"></div>
            <div class="w-2 h-10 bg-gray-400 rounded"></div>
        </div>

        <p class="text-xl font-semibold mb-4 animate-pulse">Cargando energía muscular...</p>

        <!-- Barra de progreso animada -->
        <div class="w-64 h-3 bg-gray-700 rounded-full overflow-hidden shadow-lg">
            <div class="h-full bg-gradient-to-r from-rose-400 via-orange-400 to-amber-300 animate-slide-progress rounded-full"></div>
        </div>
    </div>


    <!-- Main content -->
    <main class="flex-1 container mx-auto px-4 py-6">
        <div id="contenido" class="hidden animate-fade-in">
            {{ $slot }}
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-gradient-to-r from-black to-gray-500 text-white text-center py-3">
        <p class="text-sm">&copy; {{ date('Y') }} Mi Página Fitness. Todos los derechos reservados.</p>
    </footer>

    @livewireScripts
    @stack('script')

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const loader = document.getElementById('loader');
            const contenido = document.getElementById('contenido');

            const mostrarContenido = () => {
                // Esperar al menos 1 segundo antes de mostrar
                setTimeout(() => {
                    loader.style.display = 'none';
                    contenido.classList.remove('hidden');
                }, 100);
            };

            if (window.livewire) {
                window.livewire.hook('message.processed', mostrarContenido);
            } else {
                window.addEventListener('load', mostrarContenido);
            }
        });
    </script>

    <style>
        @keyframes slide-progress {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        .animate-slide-progress {
            animation: slide-progress 1.5s infinite linear;
        }
        @keyframes fade-in {
            from { opacity: 0; transform: scale(0.5); }
            to { opacity: 1; transform: scale(1); }
        }
        .animate-fade-in {
            animation: fade-in 1s ease-out;
        }
    </style>
</body>
</html>
