<div class="p-6 bg-white rounded-lg shadow space-y-6">
    <div class="text-xl font-semibold text-gray-800">
        Fecha: {{ $horario->fecha->format('d-m-Y') }}
    </div>
    <div class="text-md text-gray-600">
        Hora: {{ $taller->inicio->format('H:i') }}
    </div>
    @livewire('admin.agregar-persona-lista',[$taller->id])

    @forelse ($personas->sortBy('nombres') as $persona)
        <div class="border-t pt-4 mt-4 flex flex-col md:flex-row md:items-center md:justify-between space-y-2 md:space-y-0">
            @php
                $msg = "Hola, {$persona->nombres} soy Juan Carlos del Club Deportivo Kardiafit. ";
                $msg .= "Quisiera confirmar tu asistencia a la clase reservada para hoy ";
                $msg .= "({$horario->fecha->format('d-m-Y')} a las {$taller->inicio->format('H:i')} hrs). ";
                $msg .= "Si no podrás asistir, por favor anula tu reserva ingresando a www.kardiafit.cl con tu usuario y contraseña, ";
                $msg .= "o directamente desde este enlace: https://www.kardiafit.cl/perfil/{$persona->qrcode} ";
                $msg .= "Así podremos darle la oportunidad a otra persona de ocupar ese cupo. ¡Muchas gracias!";
            @endphp

            <div class="flex-1 space-y-1">
                <a href="http://wa.me/{{$persona->movil}}?text={{ urlencode($msg) }}" target="_blank">
                    <div class="font-medium text-gray-800">
                        {{ $persona->id }} - {{ $persona->nombrecompleto() }} ({{ $persona->edad() }} años)
                    </div>
                    <div class="text-sm text-gray-500">{{ $persona->movil }}</div>
                    <div class="text-sm text-gray-500">{{ $persona->email }}</div>
                </a>
            </div>

            <div class="flex gap-2 items-center">
                <div class="flex gap-1 flex-wrap text-xs">
                    @foreach ($persona->horarios->filter(fn($h) => Carbon\Carbon::parse($h->fecha)->lessThan(Carbon\Carbon::today())) as $h)
                        @if ($h->pivot->asistencia)
                            <i class="fa-solid fa-user-check text-green-600"></i> {{ $h->fecha->format('d') }}
                        @else
                            <a href="http://wa.me/{{$persona->movil}}?text={{ urlencode($this->confirmarContinuidad($h->fecha, $persona)) }}" target="_blank">
                                <i class="fa-solid fa-user-xmark text-red-600"></i> {{ $h->fecha->format('d') }}
                            </a>
                        @endif
                    @endforeach
                </div>

                <div class="text-xl">
                    @if ($this->asistido($persona->id))
                        <i class="fa-solid fa-user-check text-green-600"></i>
                    @else
                        <i class="fa-solid fa-user-xmark text-red-600"></i>
                    @endif
                </div>

                <button wire:click="confirmarAsistencia({{ $persona->id }}, true)"
                        class="px-3 py-1 bg-green-500 text-white rounded hover:bg-green-600 text-sm">
                    Confirmar
                </button>
                <button wire:click="confirmarAsistencia({{ $persona->id }}, false)"
                        class="px-3 py-1 bg-red-500 text-white rounded hover:bg-red-600 text-sm">
                    Rechazar
                </button>

                <a href="{{ asset('perfil/' . $persona->qrcode) }}" target="_blank" class="text-blue-600 underline text-sm">
                    Perfil
                </a>
            </div>
        </div>
    @empty
        <div class="text-gray-500 text-center py-6">No hay personas registradas para este horario.</div>
    @endforelse
</div>
