<div class="p-6 space-y-6 bg-white rounded-xl shadow-md">
    <div class="text-sm text-gray-600">
        <p><span class="inline-block w-4 h-4 mr-2 rounded bg-red-600"></span> Ausente</p>
        <p><span class="inline-block w-4 h-4 mr-2 rounded bg-green-600"></span> Presente</p>
        <p><span class="inline-block w-4 h-4 mr-2 rounded bg-yellow-600"></span> Sin marcar</p>
    </div>

    <div class="overflow-x-auto rounded-lg border border-gray-200">
        <table class="min-w-full divide-y divide-gray-200 table-auto">
            <thead class="bg-gray-100 text-gray-700 text-sm font-semibold">
                <tr>
                    <th class="px-4 py-3 text-left">Nombre completo</th>
                    <th class="px-4 py-3 text-left">Días</th>
                    <th class="px-4 py-3 text-left">Acción</th>
                    <th class="px-4 py-3 text-left">Observación</th>
                    <th class="px-4 py-3 text-right">Otro</th>
                </tr>
            </thead>
            <tbody class="text-sm divide-y divide-gray-100">
                @forelse ($personas as $persona)
                    <tr>
                        <td class="px-4 py-2 font-medium text-gray-900">
                            {{ $persona->nombrecompleto() }}

                        <td class="px-4 py-2">
                            <div class="flex gap-1">
                                @forelse ($fechas as $fechaRec)
                                    <div class="w-8 h-8 flex items-center justify-center rounded font-semibold  text-xs {{ $this->color($persona, $fechaRec) }}">
                                        {{ $fechaRec->format('d') }}
                                    </div>
                                @empty
                                    <span class="text-gray-400">Sin fechas</span>
                                @endforelse
                            </div>
                        </td>

                        <td class="px-4 py-2">
                        
                       @livewire('admin.marcar',[$persona,$persona->horarios->where('fecha',$fecha)->first()],key('marcar'.now()))

                        </td>

                        <td class="px-4 py-2 text-gray-600">
                            <!-- Puedes mostrar alguna observación si existe -->
                        </td>

                        <td class="px-4 py-2 text-right text-gray-600">
                            <!-- Otro contenido o acción -->
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-4 py-4 text-center text-red-500">
                            No hay registros disponibles.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

