<div class="max-w-md mx-auto p-6 bg-white rounded-xl shadow-md">
    <h2 class="text-lg font-bold mb-4 text-center text-blue-600">Prueba de Envío con Brevo API</h2>

    @if ($status)
        <div class="mb-4 p-3 rounded-md 
            {{ str_contains($status, '✅') ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700' }}">
            {{ $status }}
        </div>
    @endif

    <form wire:submit.prevent="send" class="space-y-3">
        <div>
            <label class="block text-sm font-medium text-gray-700">Destinatario</label>
            <input type="email" wire:model="toEmail" class="w-full border rounded-md p-2" placeholder="correo@ejemplo.com">
            @error('toEmail') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Nombre</label>
            <input type="text" wire:model="toName" class="w-full border rounded-md p-2" placeholder="Nombre del destinatario">
            @error('toName') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Asunto</label>
            <input type="text" wire:model="subject" class="w-full border rounded-md p-2" placeholder="Asunto del correo">
            @error('subject') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700">Mensaje</label>
            <textarea wire:model="message" rows="4" class="w-full border rounded-md p-2" placeholder="Escribe el mensaje..."></textarea>
            @error('message') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
        </div>

        <button type="submit"
            class="w-full bg-blue-600 text-white py-2 rounded-md hover:bg-blue-700 transition">
            Enviar Correo
        </button>
    </form>
</div>
