<div class="grid grid-cols-8 gap-4">

@forelse ($fechas as $fecha)
    <div class="mb-4 border p-4 rounded shadow-sm bg-white w-full rounded-xl">
        <!-- Mostrar la fecha -->
        <h3 class="text-lg font-semibold text-gray-700 mb-2">{{ \Carbon\Carbon::parse($fecha)->format('d-m-Y') }}</h3>

        <div class="space-y-1">
            @php
                $horariosDelDia = $horarios->filter(function($h) use ($fecha) {
                    return \Carbon\Carbon::parse($h->fecha)->toDateString() === \Carbon\Carbon::parse($fecha)->toDateString();
                });
            @endphp

            @forelse ($horariosDelDia as $horario)
            <a href="{{ route('admin.hojaasistencia', ['fecha' => $fecha, 'tallerId' => $horario->taller->id]) }}" target="_blank" class="block hover:bg-gray-100 p-2 rounded">
                <div class="text-sm text-gray-800">
                    {{ $horario->taller?->inicio->format('H:i') }} {{-- $horario->taller->nombre ?? 'Sin nombre' --}} 
                    
                    

                    @php
                        $disponibles = ($horario->taller->cupos - $horario->personas->count());
                    @endphp

                    <span class="text-green-600 font-bold">
                    {{ $disponibles > 0 ? 
                    
                    " ".$disponibles. " Disp" : "Completo"
                    
                    }} 
                    </span>
                </div>
            </a>

            @empty
                <div class="text-sm text-gray-500 italic">Sin horarios registrados para este día.</div>
            @endforelse
        </div>
    </div>
@empty
    <div class="text-center text-red-600 font-semibold">No hay fechas disponibles.</div>
@endforelse


    
</div>
