

<div class="overflow-x-auto rounded-xl shadow bg-white p-6 dark:bg-zinc-800">
    <h2 class="text-xl font-semibold mb-4 text-zinc-800 dark:text-white">Personas con clases reservadas</h2>

    @if ($personas->isEmpty())
        <div class="text-center text-zinc-600 dark:text-zinc-300">
            No hay personas con horarios asignados.
        </div>
    @else
        <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
            <thead class="bg-zinc-100 dark:bg-zinc-700">
                <tr>
                    <th class="px-4 py-2 text-left text-sm font-medium text-zinc-700 dark:text-zinc-300">#</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-zinc-700 dark:text-zinc-300">Nombre</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-zinc-700 dark:text-zinc-300">Reservas</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-zinc-100 dark:divide-zinc-700">
                @foreach ($personas as $index => $persona)
                    <tr class="hover:bg-zinc-50 dark:hover:bg-zinc-700">
                        <td class="px-4 py-2 text-sm text-zinc-600 dark:text-zinc-200">{{ $index + 1 }}</td>
                        <td class="px-4 py-2 text-sm font-semibold text-zinc-800 dark:text-white">{{ $persona->nombrecompleto() }}</td>
                        <td class="px-4 py-2 text-sm text-zinc-600 dark:text-zinc-200">{{ $persona->horarios->count() }} clase(s)</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>