<div class="max-w-xl mx-auto p-4 bg-white border rounded shadow">
    <h2 class="text-xl font-semibold mb-4">Editar Persona</h2>

    @if (session()->has('success'))
        <div class="mb-4 text-green-600 font-medium">
            {{ session('success') }}
        </div>
    @endif

    <form wire:submit.prevent="guardar" class="space-y-4">
        <div>
            <label class="block text-sm font-medium">Nombres</label>
            <input type="text" wire:model.defer="nombres" class="w-full border rounded px-3 py-2" />
            @error('nombres') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium">Apellido Paterno</label>
            <input type="text" wire:model.defer="paterno" class="w-full border rounded px-3 py-2" />
            @error('paterno') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium">Apellido Materno</label>
            <input type="text" wire:model.defer="materno" class="w-full border rounded px-3 py-2" />
            @error('materno') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium">Fecha de nacimiento</label>
            <input type="date" wire:model.defer="nacimiento" class="w-full border rounded px-3 py-2" />
            @error('nacimiento') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium">Teléfono</label>
            <input type="text" wire:model.defer="movil" class="w-full border rounded px-3 py-2" />
            @error('movil') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium">Email</label>
            <input type="email" wire:model.defer="email" class="w-full border rounded px-3 py-2" />
            @error('email') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div class="text-right">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                Guardar cambios
            </button>
        </div>
    </form>
</div>
