<div class="max-w-xl mx-auto p-6 bg-white shadow-xl rounded-2xl space-y-6 border border-gray-100">
    <h2 class="text-2xl font-semibold text-center text-blue-700">Bienvenido al Club Deportivo</h2>

    <div class="text-green-600 text-xl font-bold">{{$msgRegistroExitoso}}</div>

    <div>
        <a href="http://wa.me/+56966021859">¿Problemas para registrarte?</a>
    </div>
    {{-- Campo RUT --}}
    <div>
        <label class="block text-sm font-medium text-gray-700">RUT:</label>
        <div class="flex">
            <input 
                wire:model="rut_completo" 
                type="text" 
                placeholder="Ingresa tu RUT" 
                class="mt-1 w-full border border-gray-300 p-2 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                wire:keypress="verificarDatos" 
                wire:keydown="verificarDatos"
            > <div class="border border-gray-300 p-2 m-1  rounded-lg" wire:click="verificarDatos"><i class="fa-solid fa-user-check"></i></div>

        </div>

        <x-wireloading identificador="verificarDatos">        
        <div class="text-yellow-600">{{$mensajedelRut}}</div>
        @error('rut_completo')<div class="text-red-600 italic"> Ingrese un rut valido </div> @enderror
        
        <p class="text-sm text-gray-500 mt-1">{{ $mensajeRut }}</p>
        </x-wireloading>
    </div>

    {{-- Lógica condicional según el estado del RUT --}}
    @if(Rut::parse($rut_completo)->quiet()->isValid() and !$msgRegistroExitoso)
        @if ($personaExiste)
            {{-- LOGIN --}}
            <div class="bg-green-100 p-5 rounded-xl text-center space-y-2 shadow-sm">
                <p class="text-lg font-semibold text-green-800">¡Hola {{ $persona->nombres }}!</p>
                <p class="text-sm text-gray-700">Ingresa tu contraseña para continuar</p>
                <div>
                    
                    @livewire('users.input-login',[$persona])
                
                </div>
            </div>
        @else
            {{-- FORMULARIO DE REGISTRO --}}
            <div class="bg-blue-50 p-6 rounded-xl space-y-4 shadow-inner border border-blue-200">
                <p class="text-xl font-bold text-blue-800 text-center">¡Únete al Club Deportivo!</p>
                <p class="text-sm text-center text-blue-700 italic">
                    “Aquí no solo entrenamos el cuerpo, también forjamos amistades, disciplina y pasión. ¡Forma parte de esta gran familia!”
                </p>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Nombres:</label>
                        <input wire:model="nombres" type="text" class="w-full border p-2 rounded-lg" wire:keypress="validandoCampos()">
                        @error('nombres') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Apellido Paterno:</label>
                        <input wire:model="paterno" type="text" class="w-full border p-2 rounded-lg" wire:keypress="validandoCampos()">
                        @error('paterno') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Apellido Materno:</label>
                        <input wire:model="materno" type="text" class="w-full border p-2 rounded-lg" wire:keypress="validandoCampos()">
                        @error('materno') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Correo Electrónico:</label>
                        <input wire:model="email" type="email" class="w-full border p-2 rounded-lg" wire:keypress="validandoCampos()">
                        @error('email') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Celular:</label>
                        <input wire:model="movil" type="number" class="w-full border p-2 rounded-lg" wire:keypress="validandoCampos()">
                        @error('movil') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>


                    <div>
                        <label class="block text-sm font-medium text-gray-700">Fecha nacimiento:</label>
                        <input wire:model="nacimiento" type="date" class="w-full border p-2 rounded-lg"  wire:click="validandoCampos()">
                        @error('nacimiento') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Cree una contraseña:</label>
                        <input wire:model="passwd" type="password" class="w-full border p-2 rounded-lg" placeholder="Contraseña" wire:keypress="validandoCampos()">
                        @error('passwd') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>


                    <div class="text-center">
                        <button 
                            wire:click="guardar" 
                            class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-full transition duration-200"
                        >
                            Registrarme
                        </button>
                    </div>
                </div>
            </div>
        @endif
    @endif

    {{-- Mensaje de sesión --}}
    @if (session()->has('message'))
        <div class="bg-green-200 text-green-900 p-3 rounded-lg text-center font-medium">
            {{ session('message') }}
        </div>
    @endif
</div>
