<div class="p-4 border border-gray-200 rounded-2xl shadow-md w-72 mx-auto bg-white space-y-4 text-sm h-80">

    <!-- Fecha centrada -->
    <div class="text-xl font-bold text-gray-700 border-b pb-1 text-center">{{ 

    \Illuminate\Support\Carbon::parse($fecha)->locale('es')->translatedFormat('l d-m-Y')
    }}</div>

    @if ($inscritoHorarioId)
        @php
            $horario = $horarios->firstWhere('id', $inscritoHorarioId);
        @endphp

        <!-- Taller inscrito -->
        <div class="bg-green-50 text-green-800 p-3 rounded-xl space-y-1 shadow">
            <div>
                @if ($persona->asistenciaPorHorario($horario->id)->asistencia)
                    <div class="border border-green-600 bg-green-600 text-white text-center">Asistida <i class="fa-regular fa-circle-check "></i></div>     
                @endif
                 @if ($persona->asistenciaPorHorario($horario->id)->asistencia === 0)
                    <div class="border border-red-600 bg-red-600 text-white text-center">No Asistida <i class="fa-regular fa-circle-xmark"></i></div>     
                @endif
                
            </div>
            <div class="font-semibold text-base flex items-center justify-center gap-2">
                ✅ {{ $horario?->taller?->nombre }} 

            </div>
            <div class="flex items-center justify-center gap-1 text-green-600 text-xs">
                
                <div class="text-xl font-bold"><i class="fa-regular fa-clock pr-4 text-lg "></i>{{ $horario?->taller?->inicio->format('H:i') }}</div>
                
            </div>
            <div class="text-xs text-gray-500 mt-1 text-center">
                <span class="font-medium">Cupos:</span> {{ $horario?->taller?->cuposDisponibles($fecha) }}
            </div>
        </div>

        <!-- Otros talleres disponibles -->
        @php
            $otros = $talleres->where('id', '!=', $horario?->taller?->id);
        @endphp

        @if ($otros->count())
            <div class="bg-gray-50 rounded-xl p-2 shadow-inner">
                <div class="text-xs text-gray-500 font-semibold mb-2 text-center">Otros talleres disponibles</div>
                <div class="space-y-2">
                    @foreach ($otros as $tallerdisponible)
                        <div class="flex justify-between items-center px-2 py-1 bg-white rounded-md hover:bg-gray-100 text-gray-700 text-xs">
                            <div>
                                <div class="font-medium">{{ $tallerdisponible->nombre }}</div>
                                <div class="flex items-center gap-1 text-gray-500 text-[11px]">
                                    <i class="fa-regular fa-clock"></i>
                                    {{ $tallerdisponible->inicio->format('H:i') }} &bull;
                                    Cupos: {{ $tallerdisponible->cuposDisponibles($fecha) }}
                                </div>
                            </div>                            
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Botón eliminar -->
        <div class="text-center">
            <button 
                wire:click="eliminar"
                class="mt-3 text-red-500 hover:text-red-700 text-xs font-semibold"
                title="Eliminar inscripción"
            >
                ❌ Anular Reserva
            </button>
        </div>
    @else
        <!-- Lista de talleres -->
        <div class="space-y-2">
            @forelse ($talleres as $taller)
                <div class="flex justify-between items-center px-3 py-2 bg-gray-50 rounded-lg hover:bg-gray-100 shadow-sm">
                    <div class="text-left">
                        <div class="text-gray-800 font-medium">{{ $taller->nombre }}</div>
                        <div class="text-xs text-gray-500 flex items-center gap-1">
                            <i class="fa-regular fa-clock"></i>
                            {{ $taller->inicio->format('H:i') }}
                            &bull;
                            <span>Cupos: {{ $taller->cuposDisponibles($fecha) }}</span>
                        </div>
                    </div>
                    @if ($taller->cuposDisponibles($fecha)>0)
                        <input 
                        type="checkbox" 
                        wire:click="grabar({{ $taller->id }})"
                        class="text-blue-600 focus:ring focus:ring-blue-300"
                        />
                    @else
                        <i class="fa-solid fa-user-xmark text-red-600"></i>
                    @endif
                    
                </div>
            @empty
                <div class="text-gray-400 text-sm text-center">Sin talleres disponibles</div>
            @endforelse
        </div>
    @endif

</div>
