<div class="space-y-6 p-4 bg-white rounded-xl shadow-md">

    @forelse ($talleres as $taller)
        <div class="border border-gray-200 rounded-lg p-4 shadow-sm">
            <div class="text-lg font-semibold text-gray-800 mb-2">
                {{ $taller->nombre }}
            </div>

            @php
                $reservasTaller = $reservas->where('taller_id', $taller->id);
            @endphp

            @if ($reservasTaller->isEmpty())
                <div class="text-sm text-gray-400">No hay reservas para este taller.</div>
            @else
                <ul class="space-y-1 text-sm text-gray-700">
                    @foreach ($reservasTaller as $reserva)
                        <li class="flex items-center justify-between bg-gray-50 rounded px-3 py-1">
                            <span>{{ \Carbon\Carbon::parse($reserva->fecha)->format('d/m/Y') }} {{ \Carbon\Carbon::parse($reserva->taller->inicio)->format('H:i') }}</span>
                            <button 
                                wire:click="eliminar({{ $reserva->id }})" 
                                class="text-red-500 hover:text-red-700 text-xs font-semibold"
                            >
                                Eliminar
                            </button>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>
    @empty
        <div class="text-gray-500 text-center text-sm">No hay talleres disponibles.</div>
    @endforelse

</div>
