<div class="space-y-6 grid grid-cols-4 gap-4">
    @forelse ($fechas as $fecha)
        <div class="bg-white shadow rounded-lg p-4">
            <h2 class="text-xl font-semibold text-gray-800 border-b pb-2 mb-4">
                {{ \Carbon\Carbon::parse($fecha)->locale('es')->translatedFormat('l d F Y') }}
            </h2>

            @forelse ($talleres as $taller)
            <a href="{{ route('admin.hojaasistencia', [$fecha->format('Y-m-d'), $taller->id]) }}" target="_blank">

                <div class="mb-4 p-4 bg-gradient-to-r from-blue-100 to-white border border-blue-200 rounded-lg">
                    <div class="flex justify-between items-center">
                        <h3 class="text-lg font-bold text-blue-900">{{ $taller->nombre }}</h3>
                        <span class="text-sm text-gray-700">
                            Cupos: 
                            <span class="font-semibold">{{ $taller->cuposDisponibles($fecha) }}</span> 
                            de {{ $taller->cupos }}
                        </span>
                    </div>

                    {{-- Aquí puedes agregar el componente si deseas --}}
                    {{-- @livewire('talleres.lista-asistencia', [$fecha, $taller->id]) --}}
                </div>
            </a>
            @empty
                <p class="text-sm text-gray-500 italic">No hay talleres registrados para esta fecha.</p>
            @endforelse
        </div>
    @empty
        <p class="text-center text-gray-500">No hay fechas disponibles.</p>
    @endforelse
</div>
