<div>
     <!-- Botón Exportar -->
    <div class="flex justify-end mb-4">
        <button onclick="exportarPDF()" class="bg-red-600 hover:bg-red-700 text-white font-semibold px-4 py-2 rounded shadow">
            <i class="fas fa-file-pdf mr-2"></i> Exportar a PDF
        </button>
    </div>
<div class="max-w-4xl mx-auto px-6 bg-white rounded-xl shadow-lg " id="pdf-content">
   

    <!-- Encabezado con logo -->
    <div class="flex justify-center">
        <img src="<?php echo e(asset('img/logo_gore_core_horizontal_color (1).png')); ?>" alt="Logo" class="h-25">
    </div>

    <!-- Información del taller -->
    <div class="text-left">
        <h2 class="text-xl font-bold uppercase text-gray-700  text-center">Lista de Asistencia Fondo Comunidad (8%)</h2>
        <p><strong>Actividad o Taller:</strong> Taller de Fitness</p>
        <p><strong>Proyecto:</strong> ID 24845 FDNR 7% 2024</p>
        <p><strong>Organización:</strong> Club Deportivo Kardiafit</p>
        <p class="font-bold uppercase text-lg mt-2"><?php echo e($fecha->locale('es')->translatedFormat('l d-M-Y')); ?></p>
    </div>

    <!-- Tabla de asistencia -->
    <div >
        <table class="w-full text-sm  border-collapse">
            <thead>
                <tr>
                    <th colspan="4" class="text-left text-lg font-semibold px-4 py-2">
                        <?php echo e($taller->nombrecompleto()); ?>

                    </th>
                </tr>
                <tr class="text-black">
                    <th class="px-3 py-2 border border-black text-center">Nombre Beneficiario</th>
                    <th class="px-3 py-2 border border-black text-center">RUT</th>
                    <th class="px-3 py-2 border border-black text-center">Teléfono</th>
                    <th class="px-3 py-2 border border-black text-center">Firma</th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $personas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $persona): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border border-black">
                        <td class="px-3 py-2 border border-black"><?php echo e($persona->nombrecompleto()); ?></td>
                        <td class="px-3 py-2 border border-black"><?php echo e($persona->ci()); ?></td>
                        <td class="px-3 py-2 border border-black"><?php echo e($persona->movil); ?></td>
                        <td class="px-3 py-2 border border-black"></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center py-4 text-red-600">No hay registros</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!--[if BLOCK]><![endif]--><?php for($i = 0; $i < $taller->cuposDisponibles($fecha); $i++): ?>
                    <tr class="border border-black">
                        <td class="px-3 py-2 border border-black">&nbsp;</td>
                        <td class="px-3 py-2 border border-black"></td>
                        <td class="px-3 py-2 border border-black"></td>
                        <td class="px-3 py-2 border border-black"></td>
                    </tr>
                <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>
</div>

</div>

<!-- html2pdf script -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>
<script>
    function exportarPDF() {
        const element = document.getElementById('pdf-content');

        const opt = {
            margin:       [0.5, 0.5, 0.7, 0.5], // margen inferior mayor para el pie
            filename:     'asistencia_<?php echo e($fecha->format("Ymd")); ?>-[<?php echo e($taller->inicio->format("H-i")); ?>].pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 2 },
            jsPDF:        { unit: 'in', format: 'letter', orientation: 'portrait' }
        };

        const tallerNombre = <?php echo json_encode($taller->nombrecompleto(), 15, 512) ?>;
        const fechaTexto = <?php echo json_encode($fecha->locale('es')->translatedFormat('l d-M-Y'), 15, 512) ?>;

        html2pdf().from(element).set(opt).toPdf().get('pdf').then(function (pdf) {
            const totalPages = pdf.internal.getNumberOfPages();
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();

            for (let i = 1; i <= totalPages; i++) {
                pdf.setPage(i);
                pdf.setFontSize(9);
                pdf.setTextColor(100);
                const texto = `${tallerNombre} - ${fechaTexto} - Página ${i} de ${totalPages}`;
                pdf.text(texto, pageWidth / 2, pageHeight - 0.3, { align: 'center' });
            }
        }).save();
    }
</script>


<?php /**PATH C:\laravel\k2025\resources\views/livewire/talleres/lista-asistencia.blade.php ENDPATH**/ ?>